---------------------------
-- Initialization phase

if not dLocus then
   dLocus= Vec2(0,-180) ;
end

if not gActive then
   gActive = 2.5 --9999 --3
end 

-- Allocate a velocity particle property as a Vec2
pVelocity = Allocate(2) ;
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

vR = fRange(0,1);
vG = fRange(0,1);
vB = fRange(0,1);

-- Initialize values
pPosition:Init( fRange( Vec2(-200,-400), Vec2(200,000) ) + dLocus );
pVelocity:Init( fRange( Vec2(-240,190), Vec2(150,320) ) );
pColor:Init( Color(vR,vG,vB,1) );
pScale:Init( fRange( 0.7, 1.1 ) );
pAge:Init(0);
pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpinSpeed:Init( fRange( 0.8, 2.2 ) );


-- Set the particle texture
SetTexture("littlepaper");

-- Set the blend mode
SetBlendMode(kBlendNormal);


-- Initialize the raw particles--do this last in the Initialization Phase
SetNumParticles(80);

---------------------------
-- Action phase

-- Animate the velocity, position and scale
--pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,1800)) );
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pScale:Anim( pScale - fTimeScale(0.07) );

pAge:Anim( pAge+fAge() );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pUp:Anim( f2dRotation( pSpin ) );
Anim( fExpire( fGreater(pAge,4000) ) );
--pColor:Anim( fFade(pAge, Color(vR,vG,vB,0), 500, Color(vR,vG,vB,1) ,3000,Color(vR,vG,vB,1) ,500,Color(vR,vG,vB,0) ) );

-- Create an initial particle
--CreateParticles( 1 );


-- A global variable that we can set from outside
--gActive = 1

-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   if gActive>0 then
      CreateParticles( seconds * 120 );
      gActive = gActive - seconds
   end
end

